
//////////////////////////
//Created by LostSinner//
////////////////////////
using System; 
using Server; 
using Server.Gumps; 
using Server.Network;
using Server.Items;
using Server.Mobiles;
using Server.Commands;

namespace Server.Gumps
{
    public class MerlinsQuestGump1 : Gump
    {
        public static void Initialize()
        {
            CommandSystem.Register("MerlinsQuestGump1", AccessLevel.GameMaster, new CommandEventHandler(MerlinsQuestGump1_OnCommand));
        }

        private static void MerlinsQuestGump1_OnCommand(CommandEventArgs e)
        {
            e.Mobile.SendGump(new MerlinsQuestGump1(e.Mobile));
        }

        public MerlinsQuestGump1(Mobile owner)
            : base(50, 50)
        {
            //----------------------------------------------------------------------------------------------------

            AddPage(0);
            AddImageTiled(54, 33, 369, 400, 2624);
            AddAlphaRegion(54, 33, 369, 400);

            AddImageTiled(416, 39, 44, 389, 203);
            //--------------------------------------Window size bar--------------------------------------------

            AddImage(97, 49, 9005);
            AddImageTiled(58, 39, 29, 390, 10460);
            AddImageTiled(412, 37, 31, 389, 10460);
            AddLabel(140, 60, 0x34, "Merlinuv Quest by LostSinner");


            AddHtml(107, 140, 300, 230, "<BODY>" +
                //----------------------/----------------------------------------------/
"<BASEFONT COLOR=YELLOW><I>Merlin se uzasne diva jak prochazis smrticim magickym polem</I><BR><BR>" +
"<BASEFONT COLOR=YELLOW>Zda se ze jsi dokazal/a porazit Pana klice. Dobra prace! Mozna ze pro me dokazes ziskat zpet i moji magickou knihu, bez ktere jsem pouhe nic. " +
"<BASEFONT COLOR=YELLOW> Mordrid mi ji ukradl, kdyz mne zde uveznil. V mem stavu nemam sanci ho sam porazit."+
"<BASEFONT COLOR=YELLOW> Dej mi Kouli ochrany a ja pomoci energie, ktera je v ni ukryta, vykouzlim branu vedouci primo k Mordridovi.<BR>Musis ho porazit a pak se vratit zpet za mym studentem.<BR><BR>" +
// "<BASEFONT COLOR=YELLOW> As you begin to go through the gate Merlin stops you and hands you a set of earrings. Take these to aid you in your fight.<BR><BR>"+

            "</BODY>", false, true);


            AddImage(430, 9, 10441);
            AddImageTiled(40, 38, 17, 391, 9263);
            AddImage(6, 25, 10421);
            AddImage(34, 12, 10420);
            AddImageTiled(94, 25, 342, 15, 10304);
            AddImageTiled(40, 427, 415, 16, 10304);
            AddImage(-10, 314, 10402);
            AddImage(56, 150, 10411);
            AddImage(155, 120, 2103);
            AddImage(136, 84, 96);

            AddButton(250, 375, 4005, 4007, 1, GumpButtonType.Reply, 0);
            AddLabel(280, 375, 1152, "Give him the Sphere");
            AddButton(110, 375, 4005, 4007, 0, GumpButtonType.Reply, 0);
            AddLabel(140, 375, 1152, "Not right now");

            //--------------------------------------------------------------------------------------------------------------
        }

        public override void OnResponse(NetState state, RelayInfo info) //Function for GumpButtonType.Reply Buttons 
        {
            Mobile from = state.Mobile;

            if (info.ButtonID == 1)
            {
                if (from.Backpack.ConsumeTotal(typeof(SphereOfProtection), 1))
                {
                    Item item = new MordridTeleporter();
                    item.Location = from.Location;
                    item.Map = from.Map;
                    from.SendMessage("Goodluck");
                }
            }
            if (info.ButtonID == 2)
            {
                from.SendMessage("You decide to not aid Merlin");
            }
        }
    }
}

